# رفع مشکل bcrypt در Liara

## مشکل
خطای `invalid ELF header` به این دلیل است که `bcrypt` یک native module است و برای پلتفرم دیگری (Windows) compile شده و در Liara (Linux) کار نمی‌کند.

## راه حل
استفاده از `bcryptjs` به جای `bcrypt`:
- ✅ Pure JavaScript (نیاز به compile ندارد)
- ✅ API مشابه bcrypt
- ✅ در همه پلتفرم‌ها کار می‌کند
- ✅ کمی کندتر از bcrypt اما برای production کافی است

## تغییرات انجام شده

1. ✅ `backend/routes.js`: `require('bcrypt')` → `require('bcryptjs')`
2. ✅ `backend/package.json`: `"bcrypt": "^5.1.1"` → `"bcryptjs": "^2.4.3"`
3. ✅ `package.json` (root): `"bcrypt": "^5.1.1"` → `"bcryptjs": "^2.4.3"`

## نکته مهم
بعد از deploy در Liara، bcryptjs به صورت خودکار نصب می‌شود و کار می‌کند چون pure JavaScript است.

## تست
بعد از deploy، بررسی کنید که:
- ✅ Login کار می‌کند
- ✅ Password hashing کار می‌کند
- ✅ Profile update کار می‌کند

