# ✅ چک‌لیست آماده‌سازی برای Deploy در لیارا

## 📋 قبل از Deploy

### 1. فایل‌های پروژه
- [x] ✅ `liara.json` تنظیم شده است
- [x] ✅ `package.json` به‌روزرسانی شده است
- [x] ✅ `backend/package.json` شامل تمام dependencies است
- [x] ✅ `.gitignore` به‌روزرسانی شده است
- [x] ✅ `env.example` ایجاد شده است
- [x] ✅ `README.md` به‌روزرسانی شده است
- [x] ✅ `LIARA_DEPLOY.md` راهنمای کامل ایجاد شده است

### 2. دیتابیس MySQL
- [x] ✅ `backend/db.js` اتصال به MySQL پیاده‌سازی شده است
- [x] ✅ جداول به صورت خودکار ایجاد می‌شوند (`createTables()`)
- [x] ✅ Migration و Schema آماده است

### 3. امنیت
- [x] ✅ `JWT_SECRET` از متغیر محیطی استفاده می‌کند
- [x] ✅ Passwords با Bcrypt hash می‌شوند
- [x] ✅ API Keys در Environment Variables هستند

### 4. Backend
- [x] ✅ `backend/routes.js` از MySQL استفاده می‌کند
- [x] ✅ `backend/server.js` دیتابیس را initialize می‌کند
- [x] ✅ File upload با Multer پیاده‌سازی شده است
- [x] ✅ Authentication با JWT کار می‌کند

### 5. Frontend
- [x] ✅ `services/dataService.ts` از API استفاده می‌کند
- [x] ✅ `services/geminiService.ts` از Environment Variables استفاده می‌کند
- [x] ✅ Build command درست تنظیم شده است

### 6. تنظیمات لیارا
- [x] ✅ `liara.json` شامل build و start commands است
- [x] ✅ Port به درستی تنظیم شده است (3001)
- [x] ✅ Environment variables در `env.example` مستند شده‌اند

## 🚀 مراحل Deploy

### مرحله 1: آماده‌سازی در لیارا
- [ ] دیتابیس MySQL ایجاد شده است
- [ ] اپلیکیشن Node.js ایجاد شده است
- [ ] متغیرهای محیطی تنظیم شده‌اند:
  - [ ] `DB_HOST`
  - [ ] `DB_PORT`
  - [ ] `DB_USER`
  - [ ] `DB_PASSWORD`
  - [ ] `DB_NAME`
  - [ ] `JWT_SECRET`
  - [ ] `GEMINI_API_KEY`
  - [ ] `VITE_GEMINI_API_KEY`
- [ ] دیتابیس به اپلیکیشن متصل شده است

### مرحله 2: Deploy
- [ ] پروژه به Git repository push شده است
- [ ] Repository به لیارا متصل شده است
- [ ] Build command تنظیم شده است: `npm install && npm run build`
- [ ] Start command تنظیم شده است: `cd backend && npm install && npm start`
- [ ] Deploy انجام شده است

### مرحله 3: نصب اولیه
- [ ] به آدرس سایت رفته‌اید
- [ ] صفحه نصب‌کننده نمایش داده می‌شود
- [ ] اطلاعات دیتابیس وارد شده است
- [ ] مدیر کل ایجاد شده است
- [ ] نصب با موفقیت انجام شده است

### مرحله 4: تست
- [ ] ورود به پنل ادمین (`/#admin`) کار می‌کند
- [ ] ایجاد/ویرایش/حذف پروژه کار می‌کند
- [ ] ایجاد/ویرایش/حذف بلاگ کار می‌کند
- [ ] آپلود فایل کار می‌کند
- [ ] مشاوره هوشمند AI کار می‌کند
- [ ] چت ویجت کار می‌کند
- [ ] فرم تماس کار می‌کند

## 🔍 عیب‌یابی

اگر مشکلی پیش آمد:

1. **لاگ‌های سرور را بررسی کنید**:
   - در پنل لیارا به بخش Logs بروید
   - خطاهای مربوط به دیتابیس را بررسی کنید

2. **متغیرهای محیطی را بررسی کنید**:
   - مطمئن شوید همه متغیرها به درستی تنظیم شده‌اند
   - به خصوص `JWT_SECRET` و `GEMINI_API_KEY`

3. **اتصال دیتابیس را بررسی کنید**:
   - مطمئن شوید دیتابیس به اپلیکیشن متصل است
   - IP whitelist را بررسی کنید

4. **Build را بررسی کنید**:
   - مطمئن شوید که `dist` folder ایجاد شده است
   - بررسی کنید که همه dependencies نصب شده‌اند

## 📝 یادداشت‌های مهم

- ✅ پروژه برای استفاده با MySQL لیارا آماده است
- ✅ جداول به صورت خودکار در اولین اتصال ایجاد می‌شوند
- ✅ فایل‌های آپلود شده در `backend/public/uploads` ذخیره می‌شوند
- ✅ برای production بهتر است از Object Storage استفاده کنید
- ✅ SSL به صورت خودکار توسط لیارا فعال می‌شود

---

**موفق باشید! 🎉**

