# ✅ پروژه آماده برای Deploy در لیارا

## 📊 اطلاعات دیتابیس

```
Host (شبکه خصوصی): my-vira
Port: 3306
Username: root
Password: 7iyxrEhdo438xx9UZb4W37zC
Database Name: kind_ardinghelli
Version: 9.0.1
```

## 🚀 مراحل Deploy

### مرحله 1: تنظیم Environment Variables

در پنل لیارا، به بخش **Environment Variables** بروید و متغیرهای زیر را اضافه کنید:

```env
# Database
DB_HOST=my-vira
DB_PORT=3306
DB_USER=root
DB_PASSWORD=7iyxrEhdo438xx9UZb4W37zC
DB_NAME=kind_ardinghelli

# JWT Secret (یک رشته تصادفی امن ایجاد کنید)
JWT_SECRET=your-super-secret-jwt-key-min-32-characters

# Gemini AI
GEMINI_API_KEY=your-gemini-api-key
VITE_GEMINI_API_KEY=your-gemini-api-key

# Server
PORT=3001
NODE_ENV=production
```

**⚠️ نکته مهم**: 
- برای شبکه خصوصی لیارا، `DB_HOST` فقط `my-vira` است (بدون `.liara.cloud`)
- `JWT_SECRET` را با یک رشته تصادفی امن جایگزین کنید

### مرحله 2: اتصال دیتابیس

1. در پنل لیارا، به بخش **Connections** بروید
2. دیتابیس `my-vira` را به اپلیکیشن متصل کنید
3. این کار متغیرهای دیتابیس را به صورت خودکار تنظیم می‌کند

### مرحله 3: Deploy

#### روش 1: Git (پیشنهادی)

1. پروژه را در Git push کنید
2. در پنل لیارا، به بخش **Deploy** بروید
3. Source را **Git** انتخاب کنید
4. Repository را متصل کنید
5. Branch را `main` یا `master` انتخاب کنید
6. روی **Deploy** کلیک کنید

#### روش 2: Liara CLI

```bash
# نصب Liara CLI
npm install -g @liara/cli

# لاگین
liara login

# Deploy
liara deploy --app viraving-web --platform node
```

### مرحله 4: Build و Start Commands

در پنل لیارا، به بخش **Settings** > **Build & Deploy** بروید:

**Build Command:**
```bash
npm install && npm run build
```

**Start Command:**
```bash
cd backend && npm install && npm start
```

### مرحله 5: نصب اولیه

پس از deploy موفق:

1. به آدرس سایت بروید
2. صفحه نصب‌کننده نمایش داده می‌شود
3. اطلاعات دیتابیس را وارد کنید (یا اگر از Connection استفاده کرده‌اید، به صورت خودکار پر شده است)
4. مدیر کل را ایجاد کنید:
   - Username: `admin` (یا هر نام دیگری)
   - Email: ایمیل شما
   - Password: یک رمز عبور قوی
5. روی **پایان نصب و ورود** کلیک کنید

### مرحله 6: ورود به پنل مدیریت

پس از نصب، به آدرس زیر بروید:
```
https://your-domain.com/#admin
```

## ✅ چک‌لیست نهایی

قبل از deploy، مطمئن شوید:

- [x] ✅ دیتابیس MySQL در لیارا ایجاد شده است (`my-vira`)
- [ ] Environment Variables تنظیم شده‌اند
- [ ] `JWT_SECRET` یک مقدار امن است
- [ ] `GEMINI_API_KEY` و `VITE_GEMINI_API_KEY` تنظیم شده‌اند
- [ ] دیتابیس به اپلیکیشن متصل شده است
- [ ] Build command تنظیم شده است
- [ ] Start command تنظیم شده است
- [ ] Repository به Git push شده است (در صورت استفاده از Git)

## 🔍 عیب‌یابی

### مشکل اتصال به دیتابیس

- ✅ بررسی کنید که `DB_HOST` فقط `my-vira` است (بدون .liara.cloud)
- ✅ بررسی کنید که دیتابیس به اپلیکیشن متصل شده است
- ✅ لاگ‌های سرور را در پنل لیارا بررسی کنید

### مشکل در Build

- ✅ بررسی کنید که Node.js version 18+ است
- ✅ لاگ‌های build را بررسی کنید
- ✅ مطمئن شوید که همه dependencies در `package.json` هستند

### مشکل در نصب اولیه

- ✅ لاگ‌های سرور را بررسی کنید
- ✅ بررسی کنید که جداول به درستی ایجاد شده‌اند
- ✅ مطمئن شوید که دیتابیس خالی است

## 📚 فایل‌های راهنما

- `LIARA_DEPLOY.md` - راهنمای کامل نصب در لیارا
- `LIARA_ENV_SETUP.md` - راهنمای تنظیم Environment Variables
- `DEPLOY_CHECKLIST.md` - چک‌لیست کامل deploy
- `env.example` - مثال متغیرهای محیطی

## 🎉 آماده برای Deploy!

پروژه شما کاملاً آماده است. فقط کافی است:

1. Environment Variables را تنظیم کنید
2. دیتابیس را متصل کنید
3. Deploy کنید
4. نصب اولیه را انجام دهید

**موفق باشید! 🚀**

