# 🚀 راهنمای Push و Deploy در لیارا

## ✅ Git Repository آماده است!

پروژه شما commit شده و آماده push است.

## 📤 مراحل Push به Git Repository

### 1️⃣ ایجاد Repository در GitHub/GitLab/Bitbucket

اگر هنوز repository ندارید:

1. به GitHub/GitLab/Bitbucket بروید
2. یک repository جدید ایجاد کنید
3. نام repository را انتخاب کنید (مثلاً: `viraving-web`)

### 2️⃣ Push به Remote Repository

```bash
# اضافه کردن remote repository
git remote add origin https://github.com/YOUR_USERNAME/viraving-web.git

# یا اگر از SSH استفاده می‌کنید:
# git remote add origin git@github.com:YOUR_USERNAME/viraving-web.git

# Push کردن به repository
git branch -M main
git push -u origin main
```

**⚠️ توجه**: آدرس repository را با آدرس واقعی خود جایگزین کنید.

## 🚀 Deploy در لیارا

### روش 1: از طریق Git (پیشنهادی)

1. **وارد پنل لیارا شوید**: https://console.liara.ir

2. **ایجاد اپلیکیشن**:
   - به بخش **Apps** بروید
   - روی **Create App** کلیک کنید
   - نام اپلیکیشن: `viraving-web`
   - Platform: **Node.js**
   - روی **Create** کلیک کنید

3. **اتصال به Git**:
   - به بخش **Deploy** بروید
   - Source را **Git** انتخاب کنید
   - Repository خود را متصل کنید (GitHub/GitLab/Bitbucket)
   - Branch را `main` یا `master` انتخاب کنید
   - روی **Deploy** کلیک کنید

4. **تنظیم Environment Variables**:
   - به بخش **Environment Variables** بروید
   - متغیرهای زیر را اضافه کنید:

```env
DB_HOST=my-vira
DB_PORT=3306
DB_USER=root
DB_PASSWORD=7iyxrEhdo438xx9UZb4W37zC
DB_NAME=kind_ardinghelli
JWT_SECRET=<تولید کنید با: node generate-jwt-secret.js>
GEMINI_API_KEY=<کلید API گوگل>
VITE_GEMINI_API_KEY=<کلید API گوگل>
PORT=3001
NODE_ENV=production
```

5. **اتصال دیتابیس**:
   - به بخش **Connections** بروید
   - دیتابیس `my-vira` را به اپلیکیشن متصل کنید

6. **Build & Start Commands** (خودکار از liara.json):
   - Build: `npm install && npm run build`
   - Start: `cd backend && npm install && npm start`

### روش 2: از طریق Liara CLI

```bash
# نصب Liara CLI (اگر نصب نشده)
npm install -g @liara/cli

# لاگین به لیارا
liara login

# Deploy
liara deploy --app viraving-web --platform node
```

## ✅ پس از Deploy

1. **بررسی Build**:
   - در پنل لیارا، لاگ‌های build را بررسی کنید
   - مطمئن شوید که build موفق بوده است

2. **بررسی Start**:
   - لاگ‌های سرور را بررسی کنید
   - مطمئن شوید که سرور به درستی شروع شده است

3. **نصب اولیه**:
   - به آدرس سایت بروید
   - صفحه نصب‌کننده را تکمیل کنید
   - مدیر کل را ایجاد کنید

4. **ورود به پنل مدیریت**:
   - به آدرس `https://your-domain.com/#admin` بروید
   - با اطلاعات مدیر کل وارد شوید

## 🐛 عیب‌یابی

### مشکل در Build
- لاگ‌های build را در پنل لیارا بررسی کنید
- مطمئن شوید که همه dependencies در `package.json` هستند

### مشکل در Start
- لاگ‌های سرور را بررسی کنید
- مطمئن شوید که Environment Variables تنظیم شده‌اند

### مشکل اتصال به دیتابیس
- بررسی کنید که `DB_HOST` فقط `my-vira` است (بدون .liara.cloud)
- بررسی کنید که دیتابیس متصل شده است

## 📚 فایل‌های راهنما

- **QUICK_START.md** - راهنمای سریع
- **DEPLOY_READY.md** - راهنمای کامل deploy
- **LIARA_ENV_SETUP.md** - راهنمای Environment Variables

---

**موفق باشید! 🎉**

