# 🔐 تنظیمات Environment Variables در لیارا

## اطلاعات دیتابیس MySQL شما

```
Host (شبکه خصوصی): my-vira
Port: 3306
Username: root
Password: 7iyxrEhdo438xx9UZb4W37zC
Database Name: kind_ardinghelli
Version: 9.0.1
```

## 📝 متغیرهای محیطی مورد نیاز

در پنل لیارا، به بخش **Environment Variables** اپلیکیشن بروید و متغیرهای زیر را اضافه کنید:

### 1. Database Configuration

```env
DB_HOST=my-vira
DB_PORT=3306
DB_USER=root
DB_PASSWORD=7iyxrEhdo438xx9UZb4W37zC
DB_NAME=kind_ardinghelli
```

**⚠️ نکته مهم**: در لیارا، برای اتصال به دیتابیس از طریق شبکه خصوصی، فقط نام host را استفاده کنید (بدون `.liara.cloud`)

### 2. JWT Secret Key

```env
JWT_SECRET=your-super-secret-jwt-key-min-32-characters
```

**تولید JWT_SECRET امن:**
```bash
node -e "console.log(require('crypto').randomBytes(32).toString('hex'))"
```

یا می‌توانید از یک رشته تصادفی 32 کاراکتری استفاده کنید.

### 3. Gemini AI API Key

```env
GEMINI_API_KEY=your-gemini-api-key-here
VITE_GEMINI_API_KEY=your-gemini-api-key-here
```

**دریافت API Key:**
1. به https://aistudio.google.com/app/apikey بروید
2. یک API Key جدید ایجاد کنید
3. آن را در هر دو متغیر بالا قرار دهید

### 4. Server Configuration

```env
PORT=3001
NODE_ENV=production
```

**⚠️ توجه**: لیارا معمولاً `PORT` را خودکار تنظیم می‌کند، اما می‌توانید آن را به صورت دستی هم تنظیم کنید.

## ✅ چک‌لیست تنظیمات

قبل از deploy، مطمئن شوید:

- [ ] `DB_HOST` = `my-vira` (بدون .liara.cloud)
- [ ] `DB_PORT` = `3306`
- [ ] `DB_USER` = `root`
- [ ] `DB_PASSWORD` = `7iyxrEhdo438xx9UZb4W37zC`
- [ ] `DB_NAME` = `kind_ardinghelli`
- [ ] `JWT_SECRET` یک رشته امن و تصادفی است (حداقل 32 کاراکتر)
- [ ] `GEMINI_API_KEY` و `VITE_GEMINI_API_KEY` تنظیم شده‌اند
- [ ] `PORT` = `3001` (یا مقدار پیش‌فرض لیارا)
- [ ] `NODE_ENV` = `production`

## 🔗 اتصال دیتابیس به اپلیکیشن

1. در پنل لیارا، به بخش **Connections** اپلیکیشن بروید
2. دیتابیس `my-vira` را به اپلیکیشن متصل کنید
3. این کار باعث می‌شود که متغیرهای محیطی دیتابیس به صورت خودکار تنظیم شوند

**⚠️ مهم**: اگر از Connection استفاده می‌کنید، ممکن است متغیرهای محیطی به صورت خودکار تنظیم شوند. در این صورت، فقط `DB_NAME` را بررسی کنید.

## 🚀 مراحل بعدی

پس از تنظیم متغیرهای محیطی:

1. ✅ Build و Deploy را انجام دهید
2. ✅ به آدرس سایت بروید
3. ✅ صفحه نصب‌کننده را تکمیل کنید:
   - اطلاعات دیتابیس را وارد کنید (یا اگر از Connection استفاده کرده‌اید، به صورت خودکار پر شده است)
   - مدیر کل را ایجاد کنید
4. ✅ وارد پنل مدیریت شوید: `/#admin`

## 🐛 عیب‌یابی

### مشکل اتصال به دیتابیس

- ✅ بررسی کنید که `DB_HOST` فقط `my-vira` است (بدون .liara.cloud)
- ✅ بررسی کنید که دیتابیس به اپلیکیشن متصل شده است (Connections)
- ✅ لاگ‌های سرور را در پنل لیارا بررسی کنید

### مشکل در نصب

- ✅ بررسی کنید که جداول به درستی ایجاد شده‌اند
- ✅ لاگ‌های سرور را بررسی کنید
- ✅ مطمئن شوید که دیتابیس خالی است (یا جداول قبلی وجود ندارند)

---

**موفق باشید! 🎉**

