# 🚀 راهنمای سریع Deploy در لیارا

## 📋 اطلاعات دیتابیس شما

```
Host: my-vira
Port: 3306
Username: root
Password: 7iyxrEhdo438xx9UZb4W37zC
Database: kind_ardinghelli
```

## ⚡ مراحل سریع (5 دقیقه)

### 1️⃣ تنظیم Environment Variables در لیارا

در پنل لیارا → **Environment Variables** → اضافه کردن:

```env
DB_HOST=my-vira
DB_PORT=3306
DB_USER=root
DB_PASSWORD=7iyxrEhdo438xx9UZb4W37zC
DB_NAME=kind_ardinghelli
JWT_SECRET=<یک رشته تصادفی 32 کاراکتری>
GEMINI_API_KEY=<کلید API گوگل>
VITE_GEMINI_API_KEY=<کلید API گوگل>
PORT=3001
NODE_ENV=production
```

**تولید JWT_SECRET:**
```bash
node generate-jwt-secret.js
```

### 2️⃣ اتصال دیتابیس

در پنل لیارا → **Connections** → اتصال دیتابیس `my-vira` به اپلیکیشن

### 3️⃣ Deploy

**روش Git:**
- Push به Git repository
- در لیارا → Deploy → Git → Repository را متصل کنید

**روش CLI:**
```bash
liara deploy --app viraving-web --platform node
```

### 4️⃣ Build & Start Commands

در لیارا → Settings → Build & Deploy:

**Build:**
```bash
npm install && npm run build
```

**Start:**
```bash
cd backend && npm install && npm start
```

### 5️⃣ نصب اولیه

1. به آدرس سایت بروید
2. اطلاعات دیتابیس را وارد کنید (یا اگر Connection استفاده کرده‌اید، خودکار است)
3. مدیر کل را ایجاد کنید
4. ✅ تمام!

## ✅ چک‌لیست

- [ ] Environment Variables تنظیم شده‌اند
- [ ] JWT_SECRET تولید شده است
- [ ] GEMINI_API_KEY تنظیم شده است
- [ ] دیتابیس متصل شده است
- [ ] Build command تنظیم شده است
- [ ] Start command تنظیم شده است
- [ ] Deploy انجام شده است
- [ ] نصب اولیه انجام شده است

## 📚 فایل‌های راهنما

- **DEPLOY_READY.md** - راهنمای کامل با جزئیات
- **LIARA_ENV_SETUP.md** - راهنمای تنظیم Environment Variables
- **LIARA_DEPLOY.md** - راهنمای کامل لیارا
- **DEPLOY_CHECKLIST.md** - چک‌لیست کامل

## 🆘 مشکل دارید؟

1. لاگ‌های سرور را در پنل لیارا بررسی کنید
2. مطمئن شوید `DB_HOST` فقط `my-vira` است (بدون .liara.cloud)
3. بررسی کنید که دیتابیس متصل شده است

---

**موفق باشید! 🎉**

