<div align="center">
<img width="1200" height="475" alt="GHBanner" src="https://github.com/user-attachments/assets/0aa67016-6eaf-458a-adb2-6e31a0763ed6" />
</div>

# ویراوینگ - وب‌سایت شرکتی

وب‌سایت حرفه‌ای برای شرکت نرم‌افزاری ویراوینگ با قابلیت‌های مدیریت محتوا، مشاوره هوشمند AI و پنل ادمین کامل.

## ✨ ویژگی‌ها

- 🎨 طراحی مدرن و ریسپانسیو
- 🤖 مشاوره هوشمند با Google Gemini AI
- 📝 مدیریت کامل محتوا (پروژه‌ها، بلاگ، تیم، نظرات)
- 🔐 پنل ادمین با احراز هویت JWT
- 💾 دیتابیس MySQL برای production
- 🌙 حالت Dark/Light
- 📱 PWA Ready
- 💬 چت ویجت هوشمند

## 🚀 راه‌اندازی محلی

### پیش‌نیازها

- Node.js 18 یا بالاتر
- MySQL (برای production) یا استفاده از حالت Local Storage (برای development)

### نصب

```bash
# کلون کردن پروژه
git clone <repository-url>
cd viraving-web

# نصب dependencies
npm run install:all

# یا به صورت جداگانه:
npm install
cd backend && npm install
```

### تنظیمات

1. فایل `env.example` را کپی کنید و به `.env` تغییر نام دهید:
```bash
cp env.example .env
```

2. متغیرهای محیطی را در `.env` تنظیم کنید:
```env
DB_HOST=localhost
DB_PORT=3306
DB_USER=root
DB_PASSWORD=your-password
DB_NAME=viraving_db
JWT_SECRET=your-secret-key
GEMINI_API_KEY=your-gemini-api-key
VITE_GEMINI_API_KEY=your-gemini-api-key
```

### اجرا

```bash
# Development mode (Frontend + Backend)
npm run dev

# یا به صورت جداگانه:
# Terminal 1: Frontend
npm run dev

# Terminal 2: Backend
cd backend && npm run dev
```

سپس به آدرس `http://localhost:5173` بروید.

## 📦 Deploy در لیارا

### ⚡ راهنمای سریع

برای deploy سریع با اطلاعات دیتابیس شما، فایل **[DEPLOY_READY.md](./DEPLOY_READY.md)** را مطالعه کنید.

### 📚 راهنماهای کامل

- **[DEPLOY_READY.md](./DEPLOY_READY.md)** - راهنمای سریع deploy با اطلاعات دیتابیس شما
- **[LIARA_ENV_SETUP.md](./LIARA_ENV_SETUP.md)** - راهنمای تنظیم Environment Variables
- **[LIARA_DEPLOY.md](./LIARA_DEPLOY.md)** - راهنمای کامل نصب در لیارا
- **[DEPLOY_CHECKLIST.md](./DEPLOY_CHECKLIST.md)** - چک‌لیست کامل قبل از deploy

### خلاصه مراحل:

1. ایجاد دیتابیس MySQL در لیارا
2. ایجاد اپلیکیشن Node.js در لیارا
3. تنظیم متغیرهای محیطی
4. اتصال دیتابیس به اپلیکیشن
5. آپلود پروژه (Git یا CLI)
6. نصب اولیه از طریق صفحه نصب‌کننده

## 🛠️ تکنولوژی‌ها

### Frontend
- React 18
- TypeScript
- Vite
- Tailwind CSS
- Lucide Icons

### Backend
- Node.js
- Express.js
- MySQL2
- JWT Authentication
- Bcrypt
- Multer (File Upload)

### AI
- Google Gemini AI

## 📁 ساختار پروژه

```
viraving-web/
├── backend/              # سرور Node.js/Express
│   ├── db.js            # اتصال به MySQL
│   ├── routes.js        # API Routes
│   ├── server.js        # سرور اصلی
│   └── public/          # فایل‌های استاتیک
│       └── uploads/     # فایل‌های آپلود شده
├── src/                 # Frontend React
│   ├── App.tsx
│   └── main.tsx
├── components/          # کامپوننت‌های React
├── services/            # سرویس‌های Frontend
├── dist/                # Build output
├── liara.json           # تنظیمات لیارا
└── package.json         # Dependencies
```

## 🔐 امنیت

- ✅ JWT Authentication
- ✅ Password Hashing با Bcrypt
- ✅ Environment Variables برای کلیدهای API
- ✅ Input Validation
- ✅ SQL Injection Protection (Prepared Statements)

## 📝 لایسنس

این پروژه برای استفاده داخلی شرکت ویراوینگ است.

## 🤝 پشتیبانی

برای سوالات و مشکلات، با تیم توسعه تماس بگیرید.

---

**ساخته شده با ❤️ توسط تیم ویراوینگ**
