# مستندات پیاده‌سازی SEO

## ✅ بهبودهای انجام شده

### 1. به‌روزرسانی Types
- ✅ گسترش `SiteSEO` interface در `types.ts` با تمام فیلدهای SEO استاندارد:
  - Meta Tags پایه (title, description, keywords, author, canonical, robots)
  - Open Graph (og:title, og:description, og:image, og:url, og:type, og:site_name, og:locale)
  - Twitter Cards (twitter:card, twitter:site, twitter:creator, twitter:title, twitter:description, twitter:image)
  - Schema.org (schemaType, schemaName, schemaDescription, schemaLogo, schemaUrl, schemaEmail, schemaPhone, schemaAddress, schemaSameAs)
  - Analytics & Verification (googleAnalyticsId, googleSearchConsole, bingVerification, yandexVerification)
  - Additional (favicon, appleTouchIcon, themeColor)

### 2. بخش SEO Manager در پنل ادمین
- ✅ ایجاد کامپوننت `SEOManager` با 5 تب:
  1. **متا تگ‌های پایه**: Title, Description, Keywords, Author, Canonical URL, Robots, Theme Color
  2. **Open Graph**: تمام تگ‌های OG برای Facebook و LinkedIn
  3. **Twitter Cards**: تمام تگ‌های Twitter برای بهینه‌سازی اشتراک‌گذاری
  4. **Schema.org**: تنظیمات JSON-LD برای rich snippets در Google
  5. **Analytics & Verification**: Google Analytics, Search Console, Bing, Yandex

### 3. بهبود App.tsx
- ✅ پیاده‌سازی کامل SEO tags در `src/App.tsx`:
  - اعمال تمام Meta Tags
  - اعمال Open Graph Tags
  - اعمال Twitter Card Tags
  - اضافه کردن Google Analytics به صورت داینامیک
  - اضافه کردن Verification Codes
  - تولید و اضافه کردن Schema.org JSON-LD

### 4. Default Settings
- ✅ به‌روزرسانی default SEO settings در:
  - `backend/routes.js` (getDefaultSettings و installer)
  - `services/dataService.ts`

## 📋 ویژگی‌های SEO Manager

### متا تگ‌های پایه
- **Title**: با محدودیت 60 کاراکتر و راهنمای بهینه (50-60)
- **Description**: با محدودیت 160 کاراکتر و راهنمای بهینه (150-160)
- **Keywords**: با امکان وارد کردن چند کلمه کلیدی
- **Author**: نام نویسنده یا شرکت
- **Canonical URL**: برای جلوگیری از duplicate content
- **Robots Meta**: انتخاب از 4 گزینه (index/nofollow combinations)
- **Theme Color**: انتخاب رنگ برای مرورگرها

### Open Graph
- **OG Title, Description, Image**: برای بهینه‌سازی اشتراک‌گذاری در Facebook و LinkedIn
- **OG URL, Type, Site Name, Locale**: تنظیمات کامل برای شبکه‌های اجتماعی

### Twitter Cards
- **Card Type**: انتخاب بین Summary و Summary Large Image
- **Twitter Site & Creator**: @username برای Twitter
- **Twitter Title, Description, Image**: محتوای اختصاصی برای Twitter

### Schema.org
- **Schema Type**: انتخاب نوع (Organization, LocalBusiness, ProfessionalService, WebSite)
- **Schema Name, Description, Logo, URL**: اطلاعات پایه
- **Schema Email, Phone**: اطلاعات تماس
- **Schema Same As**: لیست URL شبکه‌های اجتماعی (هر URL در یک خط)

### Analytics & Verification
- **Google Analytics ID**: پشتیبانی از GA4 (G-XXXXXXXXXX) و Universal Analytics (UA-XXXXXXXXX-X)
- **Google Search Console**: کد تأیید
- **Bing Verification**: کد تأیید Bing
- **Yandex Verification**: کد تأیید Yandex

## 🚀 نحوه استفاده

1. وارد پنل ادمین شوید
2. از منوی سمت راست، روی **"SEO"** کلیک کنید
3. در هر تب، اطلاعات مربوطه را وارد کنید
4. روی **"ذخیره تنظیمات SEO"** کلیک کنید
5. تغییرات به صورت خودکار در `<head>` سایت اعمال می‌شوند

## 📊 SEO Checklist

### ✅ انجام شده
- [x] Meta Title & Description
- [x] Keywords
- [x] Canonical URL
- [x] Robots Meta
- [x] Open Graph Tags
- [x] Twitter Cards
- [x] Schema.org JSON-LD
- [x] Google Analytics
- [x] Verification Codes
- [x] Theme Color

### 🔄 قابل بهبود (پیشنهادی)
- [ ] Sitemap.xml generation
- [ ] Robots.txt file
- [ ] Alt tags برای تصاویر (در Media Manager)
- [ ] Structured Data برای Blog Posts
- [ ] Structured Data برای Projects
- [ ] Breadcrumbs Schema
- [ ] FAQ Schema
- [ ] Review Schema

## 📝 نکات مهم

1. **Title**: باید بین 50-60 کاراکتر باشد
2. **Description**: باید بین 150-160 کاراکتر باشد
3. **OG Image**: پیشنهادی 1200x630 پیکسل
4. **Twitter Image**: پیشنهادی 1200x600 پیکسل
5. **Schema.org**: برای rich snippets در Google ضروری است
6. **Google Analytics**: بعد از وارد کردن ID، به صورت خودکار اضافه می‌شود

## 🎯 نتیجه

حالا سایت شما دارای یک سیستم SEO کامل و حرفه‌ای است که تمام نیازهای استاندارد SEO را پوشش می‌دهد و آماده برای رتبه‌بندی بهتر در موتورهای جستجو است.

