# رفع مشکل SEOManager

## مشکل
```
ReferenceError: SEOManager is not defined
```

## علت
کامپوننت `SEOManager` در `AdminPanel.tsx` استفاده می‌شد اما فایل وجود نداشت (احتمالاً قبلاً حذف شده بود).

## راه حل
✅ ایجاد کامپوننت کامل `SEOManager.tsx` با تمام قابلیت‌های SEO

## ویژگی‌های SEOManager

### 5 تب اصلی:
1. **متا تگ‌های پایه**:
   - Title (با محدودیت 60 کاراکتر)
   - Description (با محدودیت 160 کاراکتر)
   - Keywords
   - Author
   - Canonical URL
   - Robots Meta
   - Theme Color

2. **Open Graph**:
   - OG Title, Description, Image
   - OG URL, Type, Site Name, Locale

3. **Twitter Cards**:
   - Card Type
   - Twitter Site & Creator
   - Twitter Title, Description, Image

4. **Schema.org**:
   - Schema Type (Organization, LocalBusiness, etc.)
   - Schema Name, Description, Logo, URL
   - Schema Email, Phone
   - Schema Same As (Social Media URLs)

5. **Analytics & Verification**:
   - Google Analytics ID
   - Google Search Console
   - Bing Verification
   - Yandex Verification

## تغییرات انجام شده

### `components/SEOManager.tsx` (ایجاد شد)
- کامپوننت کامل با 5 تب
- مدیریت state برای SEO settings
- ذخیره تنظیمات در backend
- UI/UX مناسب با Tailwind CSS

### `components/AdminPanel.tsx`
- اضافه شدن import: `import SEOManager from './SEOManager';`
- استفاده در تب SEO: `{activeTab === 'seo' && <SEOManager settings={settings} onUpdate={refreshData} />}`

## نتیجه
✅ خطای `SEOManager is not defined` برطرف شد
✅ بخش SEO در پنل ادمین کامل کار می‌کند
✅ تمام تنظیمات SEO قابل مدیریت است

