import React from 'react';

export interface Service {
  id: string;
  title: string;
  description: string;
  iconName: string; 
}

export interface ProcessStep {
  id: string;
  title: string;
  description: string;
  iconName: string;
}

export interface ProjectSEO {
  metaTitle?: string;
  metaDescription?: string;
  keywords?: string[];
  canonicalUrl?: string;
}

export interface ProjectChallenge {
  id: string;
  title: string;
  description: string;
}

export interface SiteSEO {
  // Basic Meta Tags
  title: string;
  description: string;
  keywords: string[];
  author?: string;
  canonicalUrl?: string;
  
  // Open Graph (Facebook, LinkedIn)
  ogTitle?: string;
  ogDescription?: string;
  ogImage?: string;
  ogUrl?: string;
  ogType?: string; // website, article, etc.
  ogSiteName?: string;
  ogLocale?: string;
  
  // Twitter Cards
  twitterCard?: string; // summary, summary_large_image
  twitterSite?: string; // @username
  twitterCreator?: string; // @username
  twitterTitle?: string;
  twitterDescription?: string;
  twitterImage?: string;
  
  // Robots
  robots?: string; // index, noindex, follow, nofollow
  googlebot?: string;
  
  // Analytics & Verification
  googleAnalyticsId?: string;
  googleSearchConsole?: string; // verification code
  bingVerification?: string;
  yandexVerification?: string;
  
  // Schema.org (JSON-LD)
  schemaType?: string; // Organization, LocalBusiness, etc.
  schemaName?: string;
  schemaDescription?: string;
  schemaLogo?: string;
  schemaUrl?: string;
  schemaEmail?: string;
  schemaPhone?: string;
  schemaAddress?: {
    streetAddress?: string;
    addressLocality?: string;
    addressRegion?: string;
    postalCode?: string;
    addressCountry?: string;
  };
  schemaSameAs?: string[]; // Social media URLs
  
  // Additional
  favicon?: string;
  appleTouchIcon?: string;
  themeColor?: string;
}

export interface Project {
  id: string;
  title: string;
  category: string;
  image: string;
  description: string;
  tags: string[];
  client: string;
  year: string;
  projectUrl?: string;
  seo?: ProjectSEO;
  challenges?: ProjectChallenge[]; 
}

export interface BlogPost {
  id: string;
  title: string;
  excerpt: string;
  content: string; 
  date: string;
  readTime: string;
  image: string;
  author: string;
  seo?: ProjectSEO;
}

export interface ContactMessage {
  id: string;
  name: string;
  phone: string;
  services: string[];
  description: string;
  date: string;
  isRead: boolean;
}

export interface TeamMember {
  id: string;
  name: string;
  role: string;
  image: string;
  bio: string;
  socials?: {
    linkedin?: string;
    github?: string;
    twitter?: string;
  };
}

export interface Review {
  id: string;
  name: string;
  role: string;
  text: string;
  avatar: string;
}

export interface FooterSettings {
  socials: {
    instagram?: string;
    twitter?: string;
    linkedin?: string;
    facebook?: string;
  };
  contact: {
    address: string;
    phone: string;
    email: string;
  };
}

export interface HeroSettings {
  badge: string;
  title: string;
  highlightedWord: string;
  description: string;
  ctaText: string;
}

export interface AIConfig {
  enabled: boolean;
  provider: 'gemini' | 'openai' | 'custom' | 'liara';
  apiKey?: string;
  endpoint?: string;
  modelName?: string;
  systemInstruction?: string;
}

export interface MenuItem {
  id: string;
  name: string;
  href: string;
  anchor?: string; 
  special?: boolean; 
}

export interface MobileNavItem extends MenuItem {
  iconName: string;
}

export interface NavigationSettings {
  header: MenuItem[];
  footer: {
    quickAccess: MenuItem[];
    services: MenuItem[];
  };
  mobile: MobileNavItem[];
}

export interface LegalSettings {
  terms: string;
  privacy: string;
}

export interface AppSettings {
  logoUrl?: string; 
  siteName: string;
  seo: SiteSEO;
  hero: HeroSettings;
  footer: FooterSettings;
  navigation: NavigationSettings;
  aiConfig: AIConfig;
  legal: LegalSettings;
}

export interface AIPlanResponse {
  techStack: {
    frontend: string;
    backend: string;
    database: string;
    extras: string[];
  };
  roadmap: Array<{
    phase: string;
    duration: string;
    description: string;
  }>;
  summary: string;
}

export interface AdminUser {
  username: string;
  password?: string; 
  email: string;
}

export interface DBConfig {
  host: string;
  port: string;
  name: string;
  user: string;
  pass: string;
  type: 'mysql' | 'postgres' | 'local';
}

export enum LoadingState {
  IDLE = 'IDLE',
  LOADING = 'LOADING',
  SUCCESS = 'SUCCESS',
  ERROR = 'ERROR'
}

// --- NEW Interfaces for Real Production/MySQL Environment ---

export interface PaginatedResponse<T> {
  data: T[];
  total: number;
  page: number;
  limit: number;
  totalPages: number;
}

export interface UploadResponse {
  url: string;
  filename: string;
}

export interface ChatMessage {
  id: string;
  role: 'user' | 'model';
  text: string;
  isTyping?: boolean;
}

export interface MediaItem {
  filename: string;
  url: string;
  size: number;
  createdAt: string;
}